#include <project.h>
#include "mrubyc.h"

#include "sample1.c"


#define MEMORY_SIZE (1024*30)
static uint8_t memory_pool[MEMORY_SIZE];

//================================================================
 /*! オンボードSW 現在状態の読み込み
*/
static void c_sw1_read(mrb_vm *vm, mrb_value *v, int argc)
{
  int sw1 = SW1_Read();
  SET_INT_RETURN(sw1);
}

//================================================================
/*! オンボードLED ON/OFF
*/
static void c_led1_write(mrb_vm *vm, mrb_value *v, int argc)
{
  LED1_Write(GET_INT_ARG(1));
}


//================================================================
/*! HAL （別途説明します）
*/
int hal_write(int fd, const void *buf, int nbytes)
{
  return 0;
}
int hal_flush(int fd)
{
  return 0;
}


int main()
{
  CyGlobalIntEnable; /* Enable global interrupts. */

  mrbc_init(memory_pool, MEMORY_SIZE);

  mrbc_define_method(0, mrbc_class_object, "sw1_read",   c_sw1_read);
  mrbc_define_method(0, mrbc_class_object, "led1_write", c_led1_write);

  mrbc_create_task( sample1, 0 );
  mrbc_run();

 return 0;
}
